unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMBlade, MMHook, MMDesign, MMWave, MMObj, MMDSPObj, MMTrigg, StdCtrls,
  MMsystem, MMGauge, MMCstDlg, MMUtils, ExtCtrls;
  
type
  TForm1 = class(TForm)
    Trigger: TMMTrigger;
    WaveFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    btnEncode: TButton;
    Gauge: TMMGauge;
    MP3Encoder: TMMMP3Encoder;
    btnCancel: TButton;
    OpenDialog: TMMWaveOpenDialog;
    Timer: TTimer;
    procedure btnEncodeClick(Sender: TObject);
    procedure TriggerStart(Sender: TObject);
    procedure TriggerStop(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.btnEncodeClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      WaveFile.Wave.FileName := OpenDialog.FileName;
      if MP3Encoder.FileType = ftRAW then
         MP3Encoder.FileName := CheckPath(ExtractFilePath(OpenDialog.FileName),True)+'Encode.mp3'
      else
         MP3Encoder.FileName := CheckPath(ExtractFilePath(OpenDialog.FileName),True)+'Encode.wav';
      Trigger.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStart(Sender: TObject);
begin
   btnEncode.Enabled := False;
   btnCancel.Enabled := True;
   Timer.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStop(Sender: TObject);
begin
   // close the trigger (and all other components)
   Trigger.Close;
   btnEncode.Enabled := True;
   btnCancel.Enabled := False;
   Gauge.Progress    := 0;
   Timer.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnCancelClick(Sender: TObject);
begin
   Trigger.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Trigger.Close;
end;

procedure TForm1.TimerTimer(Sender: TObject);
begin
   Gauge.Progress := Round((WaveFile.Wave.Position*100)/WaveFile.Wave.DataSize);
end;

end.
